function sys_state = Nominal_closed_sys_performance(t,xx,A,B,F,D1,C,D2,Kx,H,G,M,L)
Z = xx(1:4);
X = xx(5:6);

global Intn_u Intn_ts Intn_count Intn_tmp

d = 2*sin(2*pi*t); % disturbance
fa = f(t); % fault
xd = 1; % output tracking reference

%controller
X = X - [xd; 0];
y = C*X + D2*d + [1;1]*noise(t);
hat_x = Z + H*y;
u = Kx * hat_x(1:2);

%observer
bar_B = [B;zeros(2,1)];
GB = G*bar_B;
dot_Z = M*Z + GB*u + L*y;

% sys dynamic
dot_X = A*X + B*u + F*fa + D1*d;

% data saving 
if mod(Intn_tmp,6)==0
    Intn_count = Intn_count + 1;
Intn_ts(Intn_count) = t;
Intn_u(Intn_count) = u;
end
Intn_tmp = Intn_tmp + 1;
sys_state = [dot_Z;dot_X];